/**
  ******************************************************************************
  * @file    MDR32F9Qx_eeprom.h
  * @author  Milandr Application Team
  * @version V2.1.0
  * @date    09/12/2024
  * @brief   This file contains all the functions prototypes for the EEPROM
  *          firmware library.
  ******************************************************************************
  * <br><br>
  *
  * THE PRESENT FIRMWARE IS FOR GUIDANCE ONLY. IT AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING MILANDR'S PRODUCTS IN ORDER TO FACILITATE
  * THE USE AND SAVE TIME. MILANDR SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES RESULTING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR A USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN THEIR PRODUCTS.
  *
  * <h2><center>&copy; COPYRIGHT 2024 Milandr</center></h2>
  ******************************************************************************
  */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __MDR32F9Qx_EEPROM_H
#define __MDR32F9Qx_EEPROM_H

#ifdef __cplusplus
extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include "MDR32F9Qx_config.h"

/** @addtogroup __MDR1986BE4_StdPeriph_Driver MDR1986BE4 Standard Peripherial Driver
  * @{
  */

/** @addtogroup EEPROM
  * @{
  */

/** @defgroup EEPROM_Exported_Types EEPROM Exported Types
  * @{
  */

/**
  * @brief EEPROM Latency
  */
typedef enum
{
    EEPROM_Latency_0 = ((uint32_t)0x00), /*!< EEPROM 0 Latency cycle (MCU Clock up to 18 MHz) */
    EEPROM_Latency_1 = ((uint32_t)0x08)  /*!< EEPROM 1 Latency cycle (MCU Clock up to 36 MHz) */
} EEPROM_Latency_Cycles;

#define EEPROM_Latency_MSK      ((uint32_t)0x00000038)

#define IS_EEPROM_LATENCY(EEPROM_Latency) (((EEPROM_Latency) & (~EEPROM_Latency_MSK)) == 0x0)


/**
  * @brief EEPROM Bank Selector
  */
typedef enum
{
    EEPROM_Main_Bank_Select = ((uint32_t)0x00), /*!< EEPROM Main Bank Selector */
    EEPROM_Info_Bank_Select = ((uint32_t)0x01), /*!< EEPROM Information Bank Selector */
    EEPROM_All_Banks_Select = ((uint32_t)0x02)  /*!< EEPROM Main and Information Banks Selector (for EEPROM_EraseBlock()) */
} EEPROM_Mem_Bank;

#define IS_EEPROM_BANK_SELECTOR(SEL)    (((SEL) == EEPROM_Main_Bank_Select) || \
                                         ((SEL) == EEPROM_Info_Bank_Select))

#define IS_EEPROM_ERASE_SELECTOR(SEL)   (((SEL) == EEPROM_Main_Bank_Select) || \
                                         ((SEL) == EEPROM_All_Banks_Select))

/** @} */ /* End of group EEPROM_Exported_Types */

/** @defgroup EEPROM_Exported_Defines EEPROM Exported Defines
  * @{
  */

/**
  * @brief EEPROM parameters with a safe margin of 25% (HSI spread)
  */
#define EEPROM_TNVS_ERASE_US (13)
#define EEPROM_TNVS_PROG_US  (7)
#define EEPROM_TNVH_US       (7)
#define EEPROM_TNVH1_US      (125)
#define EEPROM_TPGS_US       (13)
#define EEPROM_TRCV_US       (2)
#define EEPROM_THV_US        (5000)

#define EEPROM_TPROG_US      (25)
#define EEPROM_TERASE_US     (25000)
#define EEPROM_TME_US        (25000)

/** @} */ /* End of group EEPROM_Exported_Defines */

/** @defgroup EEPROM_Exported_Functions EEPROM Exported Functions
  * @{
  */

/** @defgroup EEPROM_Functions_allowed_to_be_located_in_Flash Functions allowed to be located in Flash
  * @{
  */

void EEPROM_SetLatency(EEPROM_Latency_Cycles EEPROM_Latency);
EEPROM_Latency_Cycles EEPROM_GetLatency(void);

/** @} */ /* End of group EEPROM_Functions_allowed_to_be_located_in_Flash */

/** @defgroup EEPROM_Functions_not_allowed_to_be_located_in_Flash Functions not allowed to be located in Flash
  * @{
  */

__RAMFUNC uint8_t EEPROM_ReadByte(uint32_t Address, EEPROM_Mem_Bank BankSelector);
__RAMFUNC uint16_t EEPROM_ReadHalfWord(uint32_t Address, EEPROM_Mem_Bank BankSelector);
__RAMFUNC uint32_t EEPROM_ReadWord(uint32_t Address, EEPROM_Mem_Bank BankSelector);
__RAMFUNC void EEPROM_ReadWordArrayBurst(const uint32_t* PtrAddressArray, uint32_t* PtrDataArray, uint32_t ArraySize, EEPROM_Mem_Bank BankSelector);

__RAMFUNC void EEPROM_ErasePage(uint32_t Address, EEPROM_Mem_Bank BankSelector);
__RAMFUNC void EEPROM_EraseBlock(uint32_t Address, EEPROM_Mem_Bank BankSelector);

__RAMFUNC void EEPROM_ProgramByte(uint32_t Address, EEPROM_Mem_Bank BankSelector, uint32_t Data);
__RAMFUNC void EEPROM_ProgramHalfWord(uint32_t Address, EEPROM_Mem_Bank BankSelector, uint32_t Data);
__RAMFUNC void EEPROM_ProgramWord(uint32_t Address, EEPROM_Mem_Bank BankSelector, uint32_t Data);
__RAMFUNC void EEPROM_ProgramWordArrayBurst(const uint32_t* PtrAddressArray, const uint32_t* PtrDataArray, uint32_t ArraySize, EEPROM_Mem_Bank BankSelector);

__RAMFUNC void EEPROM_UpdateDCache(void);

/** @} */ /* End of group EEPROM_Functions_not_allowed_to_be_located_in_Flash */

/** @} */ /* End of group EEPROM_Exported_Functions */

/** @} */ /* End of group EEPROM */

/** @} */ /* End of group __MDR1986BE4_StdPeriph_Driver */

#ifdef __cplusplus
} // extern "C" block end
#endif

#endif /* __MDR32F9Qx_EEPROM_H */

/*********************** (C) COPYRIGHT 2024 Milandr ****************************
*
* END OF FILE MDR32F9Qx_eeprom.h */

